@php
    $pages = App\Models\Page::where('tempname', $activeTemplate)
        ->where('is_default', Status::NO)
        ->get();
    $isPages = $pages->count() > 1;

    $user = auth()->user();
    $cartUrl = null;

    // Check if user is authenticated and fetch current order
    if ($user) {
        $currentOrder = App\Models\Order::userOrders()
            ->whereIn('status', [Status::ORDER_PROCESSING, Status::ORDER_ON_DELIVERY])
            ->latest()
            ->first();
    }

    $sessionId = $user ? 0 : Session::get('session_id');

    $cartItemsQuery = \App\Models\Cart::with('user', 'restaurant', 'food');
    if ($user) {
        $cartItemsQuery->where('user_id', $user->id);
    } else {
        $cartItemsQuery->where('session_id', $sessionId);
    }
    $cartItems = $cartItemsQuery->get();
    
    // Determine cart URL based on authentication status
    $cartCount = 0;
    if (request()->routeIs('restaurant.details')) {
        if ($user) {
            // If the user is authenticated
            if (@$restaurant->id == @userInfo()['cart_restaurant_id']) {
                $cartUrl = 'javascript:void(0)';
            } else {
                $cartUrl = @userInfo()['cart_link'];
            }
            $cartCount = @userInfo()['cart_count'] ?? 0;
        } else {
            // For unauthenticated users, find the cart items using the session ID
            $sessionId = Session::get('session_id');
            $cartItemsQuery = App\Models\Cart::where('session_id', $sessionId)->with('restaurant');
            $cartCount = $cartItemsQuery->count();
            $cartItem = $cartItemsQuery->first();

            if ($cartItem && @$restaurant->id == @$cartItem->restaurant->id) {
                $cartUrl = 'javascript:void(0)';
            } else {
                $cartUrl =
                    $cartCount > 0 ? route('restaurant.details', @$cartItem->restaurant->slug) : 'javascript:void(0)';
            }
        }
    } else {
        if ($user) {
            $cartUrl = @userInfo()['cart_link'];
            $cartCount = @userInfo()['cart_count'] ?? 0;
        } else {
            $sessionId = Session::get('session_id');
            $cartItemsQuery = App\Models\Cart::where('session_id', $sessionId)->with('restaurant');
            $cartCount = $cartItemsQuery->count();
            $cartItem = $cartItemsQuery->first();
            $cartUrl =
                $cartCount > 0 ? route('restaurant.details', @$cartItem->restaurant->slug) : 'javascript:void(0)';
        }
    }

    $authenticatedUser = authenticatedUser();
@endphp

<div class="header-area">
    <div class="header-main" id="header-sticky">
        <div class="container custom-container">
            <div class="row align-items-center ">
                <div class="col-xl-2 col-lg-2 col-md-2 col-sm-3 col-12 d-flex justify-content-between">
                    <div class="logo">
                        <a href="{{ route('home') }}" class="logo-w"><img src="{{ siteLogo() }}" alt="logo-img"></a>
                    </div>
                    <div class="menu-bar d-sm-none">
                        <a class="side-toggle" href="javascript:void(0)">
                            <div class="bar-icon">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4  d-none d-xl-block">
                    <div class="main-menu-wrapper">
                        <div class="main-menu-inner d-flex align-items-center ">
                            <div class="menumain">
                                <nav id="mobile-menu">
                                    <ul>
                                        <li>
                                            <a class="link-item {{ menuActive('home') }}"
                                                href="{{ route('home') }}">@lang('Home')</a>
                                        </li>
                                        @auth()
                                            <li class="has-dropdown">
                                                <a class="link-item {{ menuActive(['all.restaurants', 'favorite.restaurants']) }}"
                                                    href="javascript:void(0)">@lang('Restaurants')</a>
                                                <ul class="submenu">
                                                    <li><a href="{{ route('search') }}">@lang('All Restaurants')</a>
                                                    </li>
                                                    <li><a href="{{ route('favorite.restaurants') }}">@lang('Favorite Restaurants')</a>
                                                    </li>
                                                </ul>
                                            </li>
                                        @else
                                            <li>
                                                <a class="link-item {{ menuActive(['all.restaurants', 'search']) }}"
                                                    href="{{ route('search') }}">@lang('Restaurants')</a>
                                            </li>
                                        @endauth

                                        @if (!$isPages && $pages->first())
                                            <li>
                                                <a class="link-item {{ menuActive('pages', [$pages->first()->slug]) }}"
                                                    href="{{ route('pages', [$pages->first()->slug]) }}">{{ __($pages->first()->name) }}</a>
                                            </li>
                                        @endif
                                        <li>
                                            <a class="link-item {{ menuActive('contact') }}"
                                                href="{{ route('contact') }}">@lang('Contact')</a>
                                        </li>

                                        @if ($isPages)
                                            <li class="has-dropdown">
                                                <a class="link-item {{ menuActive('pages') }}"
                                                    href="javascript:void(0)">@lang('Pages')</a>
                                                <ul class="submenu">
                                                    @foreach ($pages as $page)
                                                        <li>
                                                            <a
                                                                href="{{ route('pages', [$page->slug]) }}">{{ __($page->name) }}</a>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </li>
                                        @endif

                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-10 col-md-10 col-sm-9 col-12 d-xl-block">
                    <div
                        class="header-area-right d-flex align-items-center justify-content-center justify-content-sm-end cart-menu-none">

                        @include($activeTemplate . 'partials.header.current_order')

                        @include($activeTemplate . 'partials.header.cart_favorite', [
                            'cartUrl' => $cartUrl,
                        ])

                        <div class="d-none d-lg-block">
                            <div class="header-area-right__featurs d-flex  align-items-center">
                                <div class="theme-switch-wrapper">
                                    <label class="theme-switch" for="checkbox2">
                                        <input type="checkbox" id="checkbox2" class="d-none">
                                        <span class="slider round"></span>
                                    </label>
                                </div>

                                @include($activeTemplate . 'partials.header.language_box')


                            </div>
                        </div>

                        <div class="nav-right-profile d-none d-lg-block">
                            <ul class="prfile-menu">
                                <li>
                                    @include($activeTemplate . 'partials.header.user_profile_dropdown', [
                                        'authenticatedUser' => $authenticatedUser,
                                    ])
                                </li>
                            </ul>
                        </div>
                        <div class="menu-bar menu-bar-sm  d-xl-none">
                            <a class="side-toggle" href="javascript:void(0)">
                                <div class="bar-icon">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- header area end -->

<div
    class="header-area-right d-flex align-items-center justify-content-center justify-content-sm-end cart-menu d-block d-sm-none ">
    @include($activeTemplate . 'partials.header.current_order_mobile_view')
    @include($activeTemplate . 'partials.header.cart_favorite', ['cartUrl' => $cartUrl])
</div>
@include($activeTemplate . 'partials.header.sidebar')
