@php $activeAddress = $addresses->where('status', Status::ENABLE)->first(); @endphp
<div class="delivery-address">
    <div class="delivery-address__inner">
        <h4 class="title">@lang('Delivery Address') <button type="button" class="addAddressBtn"
                data-url='{{ route('user.address.update') }}'>+
                @lang('Add Address')</button></h4>

        @if ($activeAddress)
            <div class="delivery-address-box">
                <input type="hidden" name="address_id" value="{{ @$activeAddress->id }}">
                <div class="edit-tag">
                    <div class="d-inline-block select-address d-none">
                        <a href="{{ route('user.address.select', $activeAddress->id) }}" data-toggle="tooltip"
                            data-placement="top" title="Select Address" class="pencil">
                            <i class="las la-check"></i>
                        </a>
                    </div>
                    <div class="d-inline-block">
                        <button class="editAddressBtn" type="button" data-toggle="tooltip" data-placement="top"
                            title="Edit Address" data-url='{{ route('user.address.update', $activeAddress->id) }}'
                            class="pencil" data-info="{{ $activeAddress }}"><i class="las la-pen"></i>
                        </button>
                    </div>
                    <div class="d-inline-block delete">
                        <button type="button" data-toggle="tooltip" data-placement="top" title="Delete Address"
                            data-question="@lang('Are you sure to delete this address?')"
                            data-action='{{ route('user.address.delete', $activeAddress->id) }}'
                            class="trash-can confirmationBtn"><i class="las la-trash-alt"></i>
                        </button>
                    </div>
                </div>
                <h6><a
                        href="{{ route('user.address.select', $activeAddress->id) }}">{{ __(@$activeAddress->addressType()) }}</a>
                </h6>
                <p>
                    <a href="{{ route('user.address.select', $activeAddress->id) }}">{{ __(@$activeAddress->apartment) }},
                        {{ __(@$activeAddress->street) }}</a>
                </p>
            </div>

            @php
                $inActiveAddresses = $addresses->where('id', '!=', $activeAddress->id);
            @endphp

            @foreach ($inActiveAddresses as $address)
                <div class="delivery-address-box d-none">
                    <div class="edit-tag">
                        <div class="d-inline-block">
                            <a href="{{ route('user.address.select', $address->id) }}" data-toggle="tooltip"
                                data-placement="top" title="Select Address" class="pencil">
                                <i class="las la-check"></i>
                            </a>
                        </div>
                        <div class="d-inline-block">
                            <button class="editAddressBtn" type="button" data-toggle="tooltip" data-placement="top"
                                title="Edit Address" data-url='{{ route('user.address.update', $address->id) }}'
                                class="pencil" data-url='{{ route('user.address.update', $address->id) }}'
                                data-info="{{ $address }}"><i class="las la-pen"></i>
                            </button>
                        </div>
                        <div class="d-inline-block delete">
                            <button type="button" data-question="@lang('Are you sure to delete this address?')" data-toggle="tooltip"
                                data-placement="top" title="Delete Address"
                                data-action='{{ route('user.address.delete', $address->id) }}'
                                class="trash-can confirmationBtn"><i class="las la-trash-alt"></i>
                            </button>
                        </div>
                    </div>
                    <h6>
                        <a href="{{ route('user.address.select', $address->id) }}">
                            {{ __(@$address->addressType()) }}
                        </a>
                    </h6>
                    <p>
                        <a href="{{ route('user.address.select', $address->id) }}">
                            {{ __(@$address->apartment) }}, {{ __(@$address->street) }}
                        </a>
                    </p>
                </div>
            @endforeach
        @endif


        @if (count($addresses) > 1)
            <div class="view-address">
                <button>@lang('View Saved Address')</button>
            </div>
        @endif
    </div>
</div>
