@php
    if (session()->get('theme')) {
        $theme = session()->get('theme');
    } else {
        $theme = 'light';
    }
@endphp

<!doctype html>
<html lang="{{ config('app.locale') }}" itemscope itemtype="http://schema.org/WebPage" data-theme="{{ $theme }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> {{ gs()->siteName(__($pageTitle)) }}</title>
    @include('partials.seo')

    <link href="{{ asset('assets/global/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/global/css/all.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/global/css/line-awesome.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/meanmenu.css') }}">
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/main.css') }}">
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/custom.css') }}">
    @stack('style-lib')
    @stack('style')
    <link rel="stylesheet"
        href="{{ asset($activeTemplateTrue . 'css/color.php') }}?color={{ gs('base_color') }}&secondColor={{ gs('secondary_color') }}">
</head>
@php echo loadExtension('google-analytics') @endphp

<body>
    <div class="overlay"></div>
    <a href="javascript::void(0)" class="scrollToTop"><i class="las la-chevron-up"></i></a>
    <div class="preloader">
        <div class="preloader__inner">
            <img src="{{ siteLogo('dark') }}" class="preloader-logo" alt="image" />
            <img src="{{ sitePreloader() }}" class="preloader-icon" alt="img not found" />
        </div>
    </div>
    <div class="sidebar-overlay"></div>

    @stack('fbComment')
    @yield('panel')
    @include($activeTemplate . 'partials.cart_login_modal')

    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="{{ asset('assets/global/js/jquery-3.7.1.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/meanmenu.js') }}"></script>
    @stack('script-lib')

    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/main.js') }}"></script>
    @php echo loadExtension('tawk-chat') @endphp


    @if (gs('pn'))
        @include('partials.push_script')
    @endif

    @include('partials.notify')
    @stack('script')
    <script>
        (function($) {
            "use strict";

            $(document).ready(function() {
                $('.select2-basic').select2();

                $(document).ready(function() {
                    $(".cart-btn").on("click", function() {
                        var cartCount = parseInt($(".cart-btn .cart-count").text());
                    });
                });

                const toggleSwitch = $('.theme-switch input[type="checkbox"]');
                const currentTheme = localStorage.getItem("theme");

                if (currentTheme) {
                    $("html").attr("data-theme", currentTheme);

                    if (currentTheme === "dark") {
                        toggleSwitch.prop("checked", true);
                    }
                }

                toggleSwitch.change(function(e) {
                    var mode;
                    if ($(this).prop("checked")) {
                        mode = "dark";
                    } else {
                        mode = "light";
                    }

                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': "{{ csrf_token() }}"
                        },
                        url: "{{ route('change.theme') }}",
                        method: 'POST',
                        data: {
                            mode
                        },
                        dataType: 'json',
                        success: function(resp) {
                            if (resp.success) {
                                $("html").attr("data-theme", mode);
                                localStorage.setItem("theme", mode);
                                notify('success', resp.message);
                            } else {
                                notify('error', resp.message || resp.error);
                            }
                        },
                        error: function(xhr, status, error) {
                            notify('error', error);
                        }
                    });

                });

                $(function() {
                    $('[data-toggle="tooltip"]').tooltip()
                })

            });

            if (window.innerWidth <= 1200) {
                if ($('#carts').length) {
                    $('#carts').removeAttr('id');
                }
            }


            $('.cart-btn').on('click', function(e) {
                e.preventDefault();
                $('.your-cart.your-cart-two').toggleClass('active');
                $(".sidebar-overlay").addClass("show");
            })


            // Click event for plus button
            $(document).on('click', ".modal__product-qty__increment", function(e) {
                e.preventDefault();
                var currentVal = parseInt($('.modal__product-qty__value').val());
                if (!isNaN(currentVal)) {
                    $('.modal__product-qty__value').val(currentVal + 1);
                }
                $('.modal__product-qty__value').change();
            });

            // Click event for minus button
            $(document).on('click', ".modal__product-qty__decrement", function(e) {
                e.preventDefault();
                var currentVal = parseInt($('.modal__product-qty__value').val());
                if (!isNaN(currentVal) && currentVal > 1) {
                    $('.modal__product-qty__value').val(currentVal - 1);
                }
                $('.modal__product-qty__value').change();
            });

            // Change event for input field
            $(document).on('change', ".modal__product-qty__value", function() {
                var val = $(this).val();
                if (val < 1 || isNaN(val)) {
                    $(this).val(1);
                }
            });

            //cart quantity change
            $(document).on('change', ".cart-quantity", function(e) {
                var value = e.target.value;
                if (value < 0) {
                    $(this).val(1);
                    value = e.target.value;
                }
                changeCartQuantity($(this).data('id'), value, null);
            });

            $(document).on('click', ".cart-quantity-btn", function(e) {
                changeCartQuantity($(this).data('id'), null, $(this).data('type'));
            });

            function changeCartQuantity(cartId, quantity, type) {
                //store
                var formData = new FormData();
                var url = '{{ route('food.cart.quantity') }}';
                var token = '{{ csrf_token() }}';
                formData.append('_token', token);
                formData.append('cartId', cartId);
                quantity && formData.append('quantity', quantity);
                type && formData.append('type', type);

                $.ajax({
                    url: url,
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        if (response.success) {
                            notify('success', `@lang('Item updated in cart')`);
                            $('#cart').html(response.view)
                            $('.cart-btn-amount.cart-count').text(response.cart_count)
                        } else {
                            notify('error', response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        notify('error', error);
                    }
                });
            }

        })(jQuery);
    </script>

</body>

</html>
