@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="nearby-restaurant">
        <div class="row gy-4">
            @forelse ($restaurants as $restaurant)
                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col--xm-6">
                    <x-restaurant :restaurant="$restaurant" />
                </div>
            @empty
                <div class="dashboard-empty__message">
                    <div class="thumb">
                        <img src="{{ getImage('assets/images/empty_list.png') }}" alt="img">
                    </div>
                    <h6 class="text-center ">@lang('No favorite restaurant found')</h6>
                </div>
            @endforelse
        </div>
    </div>

    <div class="pagination-area mt-4">
        {{ paginateLinks($restaurants) }}
    </div>
@endsection

@push('style')
    @if (!$restaurants->count())
        <style>
            @media screen and (max-width: 991px) {
                .dashboard .dashboard-body {
                    min-height: 330px;
                }
            }
        </style>
    @endif
@endpush
