@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="nearby-restaurant">
        <div class="row gy-4">
            @forelse ($foods as $food)
                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col--xm-6">
                    <x-food :food="$food" :isSection="true" />
                </div>
            @empty
                <div class="dashboard-empty__message">
                    <div class="thumb">
                        <img src="{{ getImage('assets/images/empty_list.png') }}" alt="img">
                    </div>
                    <h6 class="text-center ">@lang('No favorite food found')</h6>
                </div>
            @endforelse
        </div>
    </div>

    <div class="pagination-area mt-4">
        {{ paginateLinks($foods) }}
    </div>
@endsection

@push('style')
    @if (!$foods->count())
        <style>
            @media screen and (max-width: 991px) {
                .dashboard .dashboard-body {
                    min-height: 330px;
                }
            }
        </style>
    @endif
@endpush
