@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $contact = getContent('contact_us.content', true);
    @endphp
    <section class="about section-bg-two pt-120 pb-120">
        <img class="about-shape-one" src="{{ getImage($activeTemplateTrue . 'images/about-shape.png') }}" alt="img not found">
        <img class="about-shape-one-dark" src="{{ getImage($activeTemplateTrue . 'images/about-shape-dark.png') }}"
            alt="img not found">
        <img class="contact-shape-two" src="{{ getImage($activeTemplateTrue . 'images/sim.png') }}" alt="img not found">
        <img class="contact-shape-two-dark" src="{{ getImage($activeTemplateTrue . 'images/sim-dark.png') }}"
            alt="img not found">
        <div class="container">
                <div class="row gy-4">
                    <div class="col-lg-6 d-none d-lg-block">
                        <div class="about-thumb h-100">
                            <img class="fit-image"
                                src="{{ frontendImage('contact_us', @$contact->data_values->image, '640x540') }}"
                                alt="img not found">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="contact-right">
                            <form action="{{ route('contact.submit') }}" method="post" class="signup-form verify-gcaptcha">
                                @csrf
                                <div class="signup-form-top pb-30">
                                    <div class="signup-page__content text-center">
                                        <h2>{{ __(@$contact->data_values->title) }}</h2>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" name="name" class="form-control form--control"
                                                    placeholder="none" value="{{ old('name', @$user->fullname) }}"
                                                    @if ($user && $user->profile_complete) readonly @endif required>
                                                <label for="name">@lang('Full Name')</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" name="email" class="form-control form--control"
                                                    placeholder="none" value="{{ old('email', @$user->email) }}"
                                                    @if ($user) readonly @endif required>
                                                <label for="email">@lang('Email Address')</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" name="subject" class="form-control form--control"
                                                    placeholder="none" name="{{ old('subject') }}" required>
                                                <label for="subject">@lang('Subject')</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <textarea class="form-control form--control" placeholder="Write Messages" name="message">{{ trim(old('message')) }}</textarea>
                                                <label for="message"
                                                    class="form-label textarea-input">@lang('Messages')</label>
                                            </div>
                                        </div>
                                    </div>
                                    <x-captcha />
                                    <div class="col-12 pt-10">
                                        <button type="submit" class="btn btn--base w-100 btn--md">@lang('Send Messages')</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>     
        </div>
    </section>

    @if (@$sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif

    <div class="map-area">
        <iframe src="{{ @$contact->data_values->map_embed_link }}"></iframe>
    </div>
@endsection
