@props([
    'isSection' => false,
])

@php
    $restaurantLink = '#';
    $foodName = __(strLimit($food->name, 16));
    $foodDescription = __(strLimit($food->short_description, 52));
    if ($isSection) {
        $restaurant = $food->restaurant;
        $foodName = __(strLimit($food->name, 24));
        $restaurantLink = route('restaurant.details', $restaurant->slug);
        $foodDescription = strLimit($foodDescription, 32);
        $class = 'food-section';
    }
@endphp

<div class="popular-food__item popular-food__item-style2 d-flex {{ @$class }}">
    <input type="hidden" data-food='@json($food)' class="foodData">
    <button class="heart {{ foodIsFavorite($food) }}" data-url={{ route('food.favorite', $food->id) }}><i
            class="far fa-heart"></i></button>
    @if (!$isSection)
        <button class="add" data-bs-toggle="modal" data-bs-target="#foodcart"><i class="las la-plus"></i></button>
    @endif

    <div class="popular-food__item-thumb">
        <a href="{{ $restaurantLink }}"><img
                src="{{ getImage(getFilePath('food') . '/thumb_' . $food->image, getFileThumbSize('food')) }}"
                alt="img not found"></a>
    </div>
    <div class="popular-food__item-meta">
        <div class="popular-food__item-meta-content">
            <h4 class="title">
                <a href="{{ $restaurantLink }}"
                    @if (!$isSection) data-bs-toggle="modal"
                        data-bs-target="#foodcart" @endif>
                    {{ __($foodName) }}
                </a>
            </h4>
            @if ($isSection)
                <p class="subtitle mt-2 mb-3"><i class="fas fa-utensils me-1"></i>
                    {{ __($restaurant->restaurant_name) }}
                </p>
            @else
                <p class="subtitle mt-2 mb-3"><i class="fas fa-utensils me-1"></i>
                    {{ $foodDescription }}
                </p>
            @endif

            <span class="price-range">@lang('Form') {{ __(showAmount($food->price)) }}</span>
        </div>
    </div>
</div>
