@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two sortable-table">
                            <thead>
                                <tr>
                                    <th>@lang('Restaurant')</th>
                                    <th>@lang('Plan')</th>
                                    <th>@lang('Purchased')</th>
                                    <th>@lang('Status')</th>
                                </tr>
                            </thead>
                            <tbody class="sort">
                                @forelse($restaurants as $restaurant)
                                    <tr class="sortable-table-row" data-id="{{ $restaurant->id }}">
                                        <td><a
                                                href="{{ route('admin.restaurants.detail', $restaurant->id) }}">{{ __($restaurant->restaurant_name) }}</a>
                                        </td>
                                        <td>{{ __($restaurant->plan->name) }}</td>
                                        <td>{{ showDateTime($restaurant->plan_purchased_at) }} <br>
                                            {{ diffForHumans($restaurant->plan_purchased_at) }}</td>
                                        <td> @php echo $restaurant->planStatusBadge; @endphp </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div><!-- card end -->
        </div>
    </div>
@endsection


@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/table-sortable.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/jquery-ui.js') }}"></script>
    <script src="{{ asset('assets/admin/js/table-sortable.js') }}"></script>
@endpush


@push('script')
    <script>
        function updateSortOrder(sorting) {
            var action = "{{ route('admin.plan.restaurant.sort') }}";
            var csrf = "{{ csrf_token() }}";
            sortOrderAction(sorting, action, csrf);
        }
    </script>
@endpush
