@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Restaurant')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('Categories')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($foods as $food)
                                    <tr>
                                        <td>
                                            <div class="user">
                                                <div class="thumb"><img
                                                        src="{{ getImage(getFilePath('food') . '/thumb_' . $food->image, getFileSize('food')) }}"
                                                        alt="{{ __($food->name) }}" class="plugin_bg"></div>
                                                <span class="name">{{ strLimit(__($food->name), 20) }}</span>
                                            </div>
                                        </td>

                                        <td>
                                            <a
                                                href="{{ route('admin.restaurants.detail', $food->restaurant->id) }}">{{ __($food->restaurant->restaurant_name) }}</a>
                                        </td>


                                        <td>
                                            {{ showAmount($food->price) }}
                                        </td>

                                        <td>
                                            {{ $food->categories_count }}
                                        </td>

                                        <td>
                                            @php echo $food->statusBadge @endphp
                                        </td>

                                        <td>
                                            <div class="button--group">
                                                <a href="{{ route('admin.foods.details', $food->id) }}"
                                                    class="btn btn-sm btn-outline--primary">
                                                    <i class="las la-desktop"></i> @lang('Details')
                                                </a>
                                            </div>
                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($foods->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($foods) }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="Restaurant Name" />
@endpush
