@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--lg  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Image')</th>
                                    <th>@lang('Size')</th>
                                    <th>@lang('Impression')</th>
                                    <th>@lang('Click')</th>
                                    <th>@lang('Redirect')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($advertisements as $advertisement)
                                    <tr>
                                        <td>
                                            <div class="thumb avatar avatar--md">
                                                <img id="image__{{ $advertisement->id }}"
                                                    src="{{ getImage(getFilePath('advertisement') . '/' . @$advertisement->value) }}"
                                                    alt="img not found">
                                            </div>
                                        </td>
                                        <td>
                                            {{ __(@$advertisement->size) }}
                                        </td>
                                        <td>
                                            <span class="badge badge--success"> {{ @$advertisement->impression }}</span>
                                        </td>
                                        <td>
                                            <span class="badge badge--primary">
                                                {{ @$advertisement->click }}
                                            </span>
                                        </td>
                                        <td>
                                            @if ($advertisement->redirect_url)
                                                <a target="_blank" href="{{ @$advertisement->redirect_url }}">
                                                    {{ @strLimit($advertisement->redirect_url, 30) }}
                                                </a>
                                            @else
                                                ---
                                            @endif
                                        </td>
                                        <td>
                                            @php echo $advertisement->statusBadge @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <button
                                                    data-advertisement="{{ json_encode($advertisement->only('id', 'type', 'value', 'size', 'redirect_url', 'status')) }}"
                                                    data-url = "{{ route('admin.advertisement.store', $advertisement->id) }}"
                                                    class="btn btn-sm btn-outline--primary ms-1 editBtn"><i
                                                        class="las la-pen"></i> @lang('Edit')</button>
                                                @if ($advertisement->status == Status::ENABLE)
                                                    <button class="btn btn-sm btn-outline--danger ms-1 confirmationBtn"
                                                        data-question="@lang('Are you sure to disable this advertisement?')"
                                                        data-action="{{ route('admin.advertisement.status', $advertisement->id) }}">
                                                        <i class="la la-eye-slash"></i> @lang('Disable')
                                                    </button>
                                                @else
                                                    <button class="btn btn-sm btn-outline--success ms-1 confirmationBtn"
                                                        data-question="@lang('Are you sure to enable this advertisement?')"
                                                        data-action="{{ route('admin.advertisement.status', $advertisement->id) }}">
                                                        <i class="la la-eye"></i> @lang('Enable')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($advertisements->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($advertisement) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div id="advertisementModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="">@lang('Size')</label>
                                    <select class="form-control form--control" id="size" name="size" required>
                                        <option value="">@lang('Select One')</option>
                                        @foreach (adsSizes() as $size)
                                            <option value="{{ $size }}">{{ $size }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group" id="imageDiv">
                                    <label>@lang('Image')</label>
                                    <x-image-uploader image="" class="w-100" type="advertisement" :required=false
                                        size="370X670" />
                                </div>
                                <div class="form-group">
                                    <label for="">@lang('Redirect Url')</label>
                                    <input type="text" class="form-control form--control" name="redirect_url"
                                        placeholder="@lang('Redirect Url')">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <button type="button" data-route="{{ route('admin.advertisement.store') }}" data-bs-target="#advertisementModal"
        data-bs-toggle="modal" class="btn btn-sm btn-outline--primary addBtn"
        data-url="{{ route('admin.advertisement.store') }}"><i class="las la-plus"></i>@lang('Add New')</button>
@endpush



@push('script')
    <script>
        $(function($) {
            "use strict";
            var modal = $('#advertisementModal');

            $('.editBtn').on('click', function() {
                var advertisementData = $(this).data('advertisement');
                var url = $(this).data('url');
                var filePath = "{{ route('home') . '/' . getFilePath('advertisement') }}";

                modal.find('.modal-title').text("@lang('Edit Advertisement')");
                modal.find('form').attr('action', url);

                // Populate form fields with advertisement data
                $('#size').val(advertisementData.size);
                $('#redirect_url').val(advertisementData.redirect_url);

                // Show/hide appropriate div based on type
                var image = advertisementData.value;
                if (image) {
                    var imageUrl = filePath + '/' + image;
                } else {
                    var imageUrl = '{{ getImage('') }}';
                }

                $(".image-upload-preview").css({
                    "background-image": "url('" + imageUrl + "')"
                });


                modal.modal('show');
                $('#size').change();
            });

            $('.addBtn').on('click', function() {
                modal.find('.modal-title').text("@lang('Add Advertisement')");
                modal.find('form')[0].reset();
                modal.find('form').attr('action', $(this).data('route'));
                var imageUrl = '{{ getImage('') }}';
                $(".image-upload-preview").css({
                    "background-image": "url('" + imageUrl + "')"
                });
                $('#type').change();
                $('#size').change();
            });
        });

        $('#size').on('change', function() {
            var selectedSize = $(this).val();
            if (!selectedSize) {
                $('#imageDiv .text-muted').hide();
            } else {
                $('#imageDiv .text-muted').show();
                $('#imageDiv small b:last-child').html(selectedSize);
            }
        });
    </script>
@endpush
