<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class Variant extends Model
{
    use GlobalStatus;

    public function scopeActive($query)
    {
        return $query->where('status', Status::ENABLE);
    }

    public function items()
    {
        return $this->hasMany(VariantItem::class);
    }

    public function food()
    {
        return $this->belongsTo(Food::class);
    }

}
