<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\SortOrder;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    use GlobalStatus, SortOrder;

    public function scopeActive($query)
    {
        return $query->where('status', Status::ENABLE);
    }

    public function restaurants()
    {
        return $this->hasMany(Restaurant::class);
    }
}
