<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class Address extends Model
{
    use GlobalStatus;

    public function scopeActive($query)
    {
        return $query->where('status', Status::ENABLE);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function addressType()
    {
        $html = '';
        if ($this->type == Status::USER_ADDRESS_HOME) {
            $html = 'Home';
        }
        if ($this->type == Status::USER_ADDRESS_WORK) {
            $html = 'Work';
        }
        if ($this->type == Status::USER_ADDRESS_OTHER) {
            $html = 'Other';
        }

        return $html;
    }

    public function addressData()
    {
        return $this->apartment.', '. $this->street;
    }

}
