<?php

namespace App\Http\Middleware;

use Closure;
use Auth;

class RestaurantCheck
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::guard('restaurant')->check()) {
            $restaurant = authRestaurant();
            if ($restaurant->status  && $restaurant->ev  && $restaurant->sv  && $restaurant->tv) {
                return $next($request);
            } else {
                if ($request->is('api/*')) {
                    $notify[] = 'You need to verify your account first.';
                    return response()->json([
                        'remark'=>'unverified',
                        'status'=>'error',
                        'message'=>['error'=>$notify],
                        'data'=>[
                            'is_ban'=>$restaurant->status,
                            'email_verified'=>$restaurant->ev,
                            'mobile_verified'=>$restaurant->sv,
                            'twofa_verified'=>$restaurant->tv,
                        ],
                    ]);
                }else{
                    return to_route('restaurant.authorization');
                }
            }
        }
        abort(403);
    }
}
