<?php

namespace App\Http\Controllers\Restaurant;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function categories()
    {
        $pageTitle  = 'Categories';
        $categories = Category::where('restaurant_id', authRestaurantId())->withCount('foods')->searchable(['name'])->paginate(getPaginate());
        return view('Template::restaurant.categories', compact('pageTitle', 'categories'));
    }

    public function storeCategories(Request $request, $id = 0)
    {
        $request->validate([
            'name' => 'required'
        ]);

        if ($id) {
            $category = Category::where('restaurant_id', authRestaurantId())->where('id', $id)->firstOrFail();
        } else {
            $category = new Category();
        }

        $category->name          = $request->name;
        $category->restaurant_id = authRestaurantId();
        $category->save();

        return returnBack('Category added successfully', 'success');
    }

    public function categoryStatus($id)
    {
        return Category::changeStatus($id);
    }
}
