<?php

namespace App\Http\Controllers\Restaurant\Auth;

use App\Http\Controllers\Controller;
use App\Models\RestaurantPasswordReset;
use App\Models\Restaurant;
use Illuminate\Http\Request;

class ForgotPasswordController extends Controller
{
    public function showLinkRequestForm()
    {
        $pageTitle = "Account Recovery";
        return view('Template::restaurant.auth.passwords.email', compact('pageTitle'));
    }

    public function sendResetCodeEmail(Request $request)
    {
        $request->validate([
            'value' => 'required'
        ]);

        if (!verifyCaptcha()) {
            $notify[] = ['error', 'Invalid captcha provided'];
            return back()->withNotify($notify);
        }

        $fieldType = $this->findFieldType();
        $restaurant = Restaurant::where($fieldType, $request->value)->first();

        if (!$restaurant) {
            $notify[] = ['error', 'The account could not be found'];
            return back()->withNotify($notify);
        }

        RestaurantPasswordReset::where('email', $restaurant->email)->delete();
        $code = verificationCode(6);
        $password = new RestaurantPasswordReset();
        $password->email = $restaurant->email;
        $password->token = $code;
        $password->created_at = \Carbon\Carbon::now();
        $password->save();

        $restaurantIpInfo = getIpInfo();
        $restaurantBrowserInfo = osBrowser();
        notify($restaurant, 'PASS_RESET_CODE', [
            'code' => $code,
            'operating_system' => @$restaurantBrowserInfo['os_platform'],
            'browser' => @$restaurantBrowserInfo['browser'],
            'ip' => @$restaurantIpInfo['ip'],
            'time' => @$restaurantIpInfo['time']
        ], ['email']);

        $email = $restaurant->email;
        session()->put('pass_res_mail', $email);
        $notify[] = ['success', 'Password reset email sent successfully'];
        return to_route('restaurant.password.code.verify')->withNotify($notify);
    }

    public function findFieldType()
    {
        $input = request()->input('value');

        $fieldType = filter_var($input, FILTER_VALIDATE_EMAIL) ? 'email' : 'username';
        request()->merge([$fieldType => $input]);
        return $fieldType;
    }

    public function codeVerify(Request $request)
    {
        $pageTitle = 'Verify Email';
        $email = $request->session()->get('pass_res_mail');
        if (!$email) {
            $notify[] = ['error', 'Oops! session expired'];
            return to_route('restaurant.password.request')->withNotify($notify);
        }
        return view('Template::restaurant.auth.passwords.code_verify', compact('pageTitle', 'email'));
    }

    public function verifyCode(Request $request)
    {
        $request->validate([
            'code' => 'required',
            'email' => 'required'
        ]);
        $code =  str_replace(' ', '', $request->code);

        if (RestaurantPasswordReset::where('token', $code)->where('email', $request->email)->count() != 1) {
            $notify[] = ['error', 'Verification code doesn\'t match'];
            return to_route('restaurant.password.request')->withNotify($notify);
        }
        $notify[] = ['success', 'You can change your password'];
        session()->flash('fpass_email', $request->email);
        return to_route('restaurant.password.reset', $code)->withNotify($notify);
    }
}
