<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Plan;
use App\Models\Restaurant;
use Illuminate\Http\Request;

class PlanController extends Controller
{
    public function index()
    {
        $pageTitle = "Manage Plan";
        $plans     = Plan::orderBy('sort_order')->paginate(getPaginate());
        return view('admin.plan.index', compact('pageTitle', 'plans'));
    }

    public function restaurants()
    {
        $pageTitle = "Restaurants Purchased";
        $restaurants = Restaurant::where('plan_id', '!=', 0)->with('plan');
        $hasSortOrderRestaurants = (clone $restaurants)->notExpiredPlans()->orderBy('sort_order')->get();
        $zeroSortOrderRestaurants = (clone $restaurants)->expiredPlans()->orderBy('plan_purchased_at', 'desc')->get();
        $restaurants = $hasSortOrderRestaurants->concat($zeroSortOrderRestaurants);
        return view('admin.plan.restaurants', compact('pageTitle', 'restaurants'));
    }

    public function store(Request $request, $id = 0)
    {
        $request->validate([
            'name'  => 'required',
            'time'  => 'required|numeric|gt:0',
            'price' => 'required|numeric|gt:0',
        ]);

        if ($id) {
            $plan = Plan::findOrFail($id);
            $notificationMessage = 'Plan updated successfully';
        } else {
            $plan = new plan();
            $notificationMessage = 'Plan added successfully';
        }

        $plan->name = $request->name;
        $plan->time = $request->time;
        $plan->price = $request->price;
        $plan->save();

        return returnBack($notificationMessage, 'success');
    }

    public function status($id)
    {
        return Plan::changeStatus($id);
    }

    public function sortPlan()
    {
        Plan::sortOrder();
    }

    public function sortRestaurant()
    {
        Restaurant::sortOrder();
    }
}
